/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.MultiLineLabel;

public class StringInputRO
extends MultiLineLabel
implements JDMInput {
    protected boolean hasErrorValue = false;
    protected boolean ignoreValue = false;

    public StringInputRO() {
    }

    public StringInputRO(String string) {
        super(string);
    }

    public void setText(String string) {
        super.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
        this.invalidate();
    }

    public Object getValue() {
        return new String(this.getText());
    }

    public String toString() {
        return new String(this.getText());
    }

    public void setValue(String string) {
        this.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public void setValue(Object object) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (object instanceof String) {
            this.setText((String)object);
            return;
        }
        if (object instanceof OctetString) {
            this.setText(((OctetString)object).toDisplayString());
            return;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            this.setText(n.toString());
            return;
        }
        if (object instanceof SpecialValue) {
            this.setText(object.toString());
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
                return;
            }
            this.ignoreValue = false;
            return;
        }
        this.setText(object.toString());
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

